function MyDB(){
	// tableinformations
	this.sName = "";              //name of the database (string)
	this.assTables = new Array(); //assoziatives array of tables (tableName, tableIndex) like a hashtable
	this.aTables = new Array();   //array of all tableobjects
}

MyDB.prototype.getName = function(){ return this.sName; };
MyDB.prototype.setName = function(sNewName) { this.sName = sNewName; } 
MyDB.prototype.addTable = _addTable; //Parameter(sTableName,aAttributes,aPrimaryKeys,aForeignKeys)
MyDB.prototype.dropTable = _dropTable;
MyDB.prototype.forceDropTable = _forceDropTable;
MyDB.prototype.getTableIdx = _getTableIdx;
MyDB.prototype.getAllTableNames = _getAllTableNames;
MyDB.prototype.buildAssTable = _buildAssTable;
MyDB.prototype.getAllTables = _getAllTables;

MyDB.prototype.getScheme = _getTableScheme;
MyDB.prototype.setScheme = _setScheme;

MyDB.prototype.getData = _getData;
MyDB.prototype.setData = _setData;
MyDB.prototype.insertData = _insertData; //add data-tupel needs array as parameter in correct order
MyDB.prototype.deleteAllData = _deleteAllData; //removes data from table
MyDB.prototype.deleteRowOfTable = _deleteRowOfTable; //removes data-tupel of a table. Needs rownumber starting with 0 and tablename


MyDB.prototype.getDataWithSQL = _getDataWithSQL; //transfers SQL to the sql-implementation
MyDB.prototype.buildView = _buildView; //Parameter: tableName //builds the html-code to insert in a html-page.

/******************************************/
/************** Sourcecode ****************/
/******************************************/
function _addTable(sName,aScheme,aPrimaryKeys,aReferencePairs,sDescr) {//Parameter(sTableName,aAttributes,aPrimaryKeys,aForeignKeys)
	if (sName=="") {
		alert("_addTable\n"+"Es konnte keine Tabelle angelegt werden, da kein Name bekannt war.");
		return false;
	}
	if (aScheme==null) {
		alert("_addTable\n"+"Es konnte keine Tabelle angelegt werden, da kein Schema bekannt war.");
		return false;
	}
	var newTable = new DBTable();
	newTable.setName(sName);
	newTable.setScheme(aScheme);
	newTable.setPrimaryKeys(aPrimaryKeys);
	newTable.setReferencesPair(aReferencePairs);
	//Array druchlaufen und Tabellen rausfinden
	var aReferences = new Array();
	//alert("Tabellenname:"+sName+"\n Referenzen:\n"+aReferencePairs);
	for (var i=0;i<aReferencePairs.length;i++) {
		aReferences[aReferences.length] = aReferencePairs[i][1];
	}
	//alert(aReferences);
	newTable.setReferences(aReferences);
	newTable.setDescr(sDescr);
	this.aTables[this.aTables.length] = newTable;
	this.assTables[this.assTables.length] = new Array(sName,this.aTables.length-1);
	return true;
}

function _dropTable(sTableName) {
	//alert("_dropTable:"+sTableName);
	var curTableIdx = this.getTableIdx(sTableName);
	if (curTableIdx<0) {
		alert("_drobTable\n Eine Tabelle "+sTableName+" existiert nicht.");
		return false;
	}
	//check, if another table needs this one.
	for (var i = 0;i<this.aTables.length;i++) {
		var tableNameWichUsesThisOne = this.aTables[i].checkForReferenceWith(sTableName);
		if (tableNameWichUsesThisOne!="") {
			alert("Die Tabelle >"+sTableName+"< kann nicht entfernt werden, da die Tabelle >"+tableNameWichUsesThisOne+"< eine Referenz auf sie besitzt.\n Erst die Tabelle >"+tableNameWichUsesThisOne+"< entfernen.");
			return false;
		}
	}
	//removing from tablelist
	var newTableList = new Array();
	var k = 0;
	for (var i = 0;i<this.aTables.length;i++) {
		if (i!=curTableIdx) {
			newTableList[k] = this.aTables[i];
			k++;
		}
	}
	this.aTables = newTableList;
	this.buildAssTable();
	return true;
}

function _forceDropTable(sTableName) {
	//alert("_forceDropTable:"+sTableName);
	var curTableIdx = this.getTableIdx(sTableName);
	if (curTableIdx<0) {
		alert("_drobTable\n Eine Tabelle "+sTableName+" existiert nicht.");
		return false;
	}
	//removing from tablelist
	var newTableList = new Array();
	var k = 0;
	for (var i = 0;i<this.aTables.length;i++) {
		if (i!=curTableIdx) {
			newTableList[k] = this.aTables[i];
			k++;
		}
	}
	this.aTables = newTableList;
	this.buildAssTable();
	//alert("HALT _forceDropTable:"+sTableName);
	return true;
}


function _getTableIdx(sTableName) {
	for (var i=0; i<this.assTables.length;i++) {
		if (sTableName==this.assTables[i][0]) {
			return i;
		}
	}
	return -1;
}

function _getAllTableNames() {
	var aResult = new Array();
	for (var i=0; i<this.assTables.length;i++) 	aResult[i] = this.assTables[i][0];
	return aResult;
}

function _buildAssTable() {
	this.assTables = null;
	this.assTables = new Array();
	for (var i=0; i<this.aTables.length;i++) this.assTables[i] = new Array(this.aTables[i].getName(),i);	
}

function _getAllTables() {
	return this.aTables;
}

/*************************************************/
function _getTableScheme(sTableName) {
	var curTableIdx = this.getTableIdx(sTableName);
	if (curTableIdx<0) {
		alert("_getTableScheme\n Eine Tabelle "+sTableName+" existiert nicht.");
		return;
	}
	return this.aTables[curTableIdx].getScheme();
}

function _setScheme(sTableName,aArray) {//Array of (name,type)s
	var curTableIdx = this.getTableIdx(sTableName);
	if (curTableIdx<0) {
		alert("_setScheme\n Eine Tabelle "+sTableName+" existiert nicht.");
		return;
	}
	this.aTables[curTableIdx].setScheme(aArray);
}

function _getData(sTableName) {
	var curTableIdx = this.getTableIdx(sTableName);
	if (curTableIdx<0) {
		alert("_getData\n Eine Tabelle "+sTableName+" existiert nicht.");
		return;
	}
	return this.aTables[curTableIdx].getData(false); //Parameter: debugmodus=true->String/false->Array
}

function _setData() {
	alert("_setData\n Not yet implemented.");
}

function _insertData(sTableName,aData) {
	var curTableIdx = this.getTableIdx(sTableName);
	if (curTableIdx<0) {
		alert("_insertData\n Eine Tabelle "+sTableName+" existiert nicht.");
		return;
	}
	this.aTables[curTableIdx].insertData(aData);
}

function _deleteAllData() {
	alert("_deleteAllData\n Not yet implemented.");
}


function _deleteRowOfTable(sTableName,iDataIdx) {
	var curTableIdx = this.getTableIdx(sTableName);
	this.aTables[curTableIdx].deleteData(iDataIdx);
}

function _getDataWithSQL() {
	alert("_getDataWithSQL\n Not yet implemented.");
}

function _buildView(sTableName) {
	var curTableIdx = this.getTableIdx(sTableName);
	if (curTableIdx<0) {
		alert("_buildView\n Eine Tabelle "+sTableName+" existiert nicht.");
		return;
	}
	var dataToShow = this.aTables[curTableIdx].getData(false); //Parameter: debugmodus=true->String/false->Array
	var displayString = "";
	for (intX = 0; intX < dataToShow.length; intX++) {
		displayString += "<tr><td style='border-right:1px solid #000000;'>&nbsp;<\/td>"; //first element is empty because of displaying the table
		for (intY = 0; intY < this.aTables[curTableIdx].getScheme().length; intY++){
			if (intX==dataToShow.length-1) {
				displayString += "<td class='data' style='border-bottom:1px solid #000000;margin-top:0em'>";
			} else {
				displayString += "<td class='data' style='margin-top:0em'>";
			}
			var inputLength = 10;
			if (dataToShow[intX][intY].length>10) inputLength = dataToShow[intX][intY].length;
			displayString += "<input style='font-size:1.3em' type='text' size='"+inputLength+"' id='inputField_"+sTableName+"_"+intX+intY+"' value='"+dataToShow[intX][intY]+"' onchange='top.head.updateDataEntry("+'"'+sTableName+'"'+","+[intX]+","+[intY]+","+'this.value'+")'>";
			displayString += "</td>";
		}
		displayString += "<td style='text-align:center'>&nbsp;<img src='pics/delete1.gif' alt='' width='11' height='11' onMouseOver='";
		displayString += 'this.src="pics/delete2.gif"';
		displayString += "' onMouseOut='";
		displayString += 'this.src="pics/delete1.gif"';
		displayString += "' onClick='top.head.deleteRowOfTable("+intX+","+'"'+sTableName+'"';
		//displayString += '"hallo"';
		displayString += ")'><\/td><\/tr>";
	}
	//alert("_buildView\n"+displayString);
	return displayString;
}

/******************************************/
/************** Helpers *******************/
/******************************************/
function removeElementFromArray(aArray,elementIdx) {
	if (aArray==null || aArray.length == 0 || elementIdx<-1) {return false;}
	var clearedArray = new Array();
	var vectorDim = aArray[0].length;
	var elementType = typeof aArray[0];
	var k = 0;
	for (var i = 0;i<aArray.length;i++) {
		if (i!=elementIdx) {
			if (elementType == "object") {
				clearedArray[k] = new Array(vectorDim);
				for (var j = 0;j<aArray[i].length;j++) clearedArray[k][j] = aArray[i][j];
			} else {
				clearedArray[k] = aArray[i];
			}
			k++;
		}
	}
	return clearedArray;
}