/*-------------- Globals ----------*/
var DBTest; //global datatbase
//var lastSQLStatement = "SELECT Lehrer.* \nFROM Lehrer";
var lastSQLStatement = "SELECT Spieler.SpielerID \nFROM Spieler";
var cntSQLStatements = 1;
var showTableDetails = false;
/*----------------------------------*/

function receiveData(sTableName,sScheme,aPrimKeys,aRefTables,sDescr) { 
	//called from newTable.html with receiveData(tableName,curScheme,primaryKeyAttribute,referencedTables,document.f.tabledescr.value);
	if (DBTest.addTable(sTableName,sScheme,aPrimKeys,aRefTables,sDescr)) {
		updateTableDisplay();
	}
}

function editOldTable(tableName,sDescr,curScheme,primaryKeyAttributes,foreignKeyAttributes,deletedAttributes) {
	var curTable = DBTest.getAllTables()[DBTest.getTableIdx(tableName)];
	//Beschreibung anpassen
	curTable.setDescr(sDescr);
	//Spalten lschen
	//nderung 7.2.2016
	//Die Inhalte von gelschten Spalten werden nicht gelscht.
	

	var curAttrName = "";
	for (var i=0;i<deletedAttributes.length;i++) {
		//Aus Schema lschen
		curAttrName = deletedAttributes[i][1];
		iColumnIdx = curTable.getAttributIdx(curAttrName);
		curTable.dropFromScheme(curAttrName);
		curTable.deleteColumn(iColumnIdx);
		//Aus foreignKeysliste lschen
		if (curTable.isForeignKey(curAttrName)) {
			//Tabelle, auf die verwiesen wird, freigeben
		}
	}
	//Neue Primkeys setzen
	curTable.setPrimaryKeys(primaryKeyAttributes);
	//Neue Fremdschlssel setzen
	curTable.setReferencesPair(foreignKeyAttributes);
	//Spalten hinzufgen
	for (i=0;i<curScheme.length;i++) {
		if (curTable.isNotInScheme(curScheme[i][0])) {
			curTable.addToScheme(curScheme[i][0],curScheme[i][1]);
		}
	}
	
	updateTableDisplay();
}

function reveiveSQLStatement(sSQLStatement) {
	sSQLStatement = sSQLStatement.replace(/\n/g, ' ').replace(/\r/g, '');
	var sqlWords = sSQLStatement.split(" ");
	switch (sqlWords[0]) {
		case "SELECT":
			evaluateSelectStatement(sSQLStatement)
			break;
		case "DROP":
			//DROP TABLE tablename
			if (sqlWords.length!=3) {alert("Die korrekte Angabe lautet:\nDROP TABLE tablename");return;}
			if (sqlWords[2].charAt(0)=="'" && sqlWords[2].charAt(sqlWords[2].length-1)=="'" ) sqlWords[2] = sqlWords[2].substring(1,sqlWords[2].length-1);
			if (confirm(unescape("Soll die Tabelle >"+sqlWords[2]+"< wirklich gel%F6scht werden? Es gehen dadurch Daten und Fremdschl%FCssel verloren."))) {
				DBTest.dropTable(sqlWords[2]);
				updateTableDisplay();
				top.content.document.getElementById("sqlResults").innerHTML = "";
				cntSQLStatements = 1;
			}
			break;
		case "ALTER":
			//ALTER TABLE tabellenname
			//ADD spaltenname spaltentyp ODER DROP spaltenname
			if (sqlWords[1] == "TABLE") {
				var sTableName = sqlWords[2];
				switch (sqlWords[3]) {
					case "ADD":
						if (sqlWords[5].toLowerCase() != "string" && sqlWords[5].toLowerCase() != "number" ) {
							alter("In dieser Datenbank gibt es nur 'String' und 'Number' als Datentyp.");
						} else {
							DBTest.getAllTables()[DBTest.getTableIdx(sTableName)].addToScheme(sqlWords[4],sqlWords[5]);						
						}
						break;
					case "DROP":
						DBTest.getAllTables()[DBTest.getTableIdx(sTableName)].dropFromScheme(sqlWords[4]);						
						if (DBTest.getAllTables()[DBTest.getTableIdx(sTableName)].getScheme().length == 0) {
							alert(unescape("Die Tabelle '"+sTableName+"' besitzt keine Spalten mehr und wird daher gel%F6scht."));
							DBTest.dropTable(sTableName);
						}
						updateTableDisplay();
						top.content.document.getElementById("sqlResults").innerHTML = "";
						cntSQLStatements = 1;
						break;
					default:
						alert(sqlWords[3]+" ist im Zusammenhang mit 'ALTER TABLE' keine SQL-Befehl.");					
				}
			} else {
				alert(">"+sqlWords[1]+"< ist keine SQL-Befehl. Es gibt nur 'ALTER TABLE'.");
			}
			break;
		case "CREATE":
			alert(unescape("Tabellen bitte %FCber %5BNeue Tabelle%5D definieren. Sogenannte Views k%F6nnen nicht angelegt werden."));
			break;
		case "DELETE":
			//DELETE FROM tablename WHERE bedingung
			//Es wird nur 1 Bedingung untersttzt
			break;
		default:
			alert(unescape("'"+sqlWords[0]+"' ist keine korrekter SQL-Begriff. Nur SELECT, DROP, ALTER und CREATE sind m%F6glich."));
	}
}

function evaluateSelectStatement(sSQLStatement) {
	//Building complete(!) scheme-string of all tables
	var schemeString = "var schema = {";
	for (var tableIdx = 0; tableIdx<DBTest.getAllTableNames().length;tableIdx++) {
		var curTableName = DBTest.getAllTableNames()[tableIdx];
		schemeString += getTrimPathScheme(curTableName);
		if (tableIdx < DBTest.getAllTableNames().length-1) schemeString += ",";
	}
	schemeString += "};";
	try {
		eval(schemeString);
	} catch (e) {
		alert("mydbms.js\n Zeile 118\n Das Schema war nicht korrekt angegegben.");
		return;
	}
	
	//Building complete(!) table-string of all tables
	var tableString = "var tableData = {";
	for (var tableIdx = 0; tableIdx<DBTest.getAllTableNames().length;tableIdx++) {
		var curTableName = DBTest.getAllTableNames()[tableIdx];
		tableString += getTrimPathTableData(curTableName);
		if (tableIdx < DBTest.getAllTableNames().length-1) tableString += ",";
	}
	tableString += "};";
	eval(tableString);
	try {
		//eval(tableString);
	} catch (e) {
		alert("mydbms.js\n Zeile 133\n Die Ergebnis-Tabelle konnte nicht angelegt werden.");
		alert(tableString);
	}

	//Evaluating
	var queryLang = top.head.TrimPath.makeQueryLang(schema);
	try {
		var statement = queryLang.parseSQL(sSQLStatement);
	} catch (e) {
		alert(unescape("Die eingegebene SQL-Abfrage war nicht korrekt. Schau nochmal in die Hilfe.\n\nUm Operatoren m%FCssen Leerzeichen eingef%FCgt sein. Also %22Spalte.Name "+aOperators[j]+" 100%22 statt %22Spalte.Name"+aOperators[j]+"100%22. "));
		return false;
	}

	var evaluationOkay = true;
	try {
		var resultOfEvaluation = statement.filter(tableData);
	} catch (e) {
		evaluationOkay = false;
	}
	if (evaluationOkay) {
		var out = "<a name='abfrage_"+cntSQLStatements+"'><\/a>";
		out += "<div class='result'>";	
		out += "<h3>"+cntSQLStatements+". Abfrage</h3><div class='sqlstatement'>"+breakIntoRows(sSQLStatement)+"<\/div>";
		if (resultOfEvaluation=="") {
			out += "<span class='resultData'>Es wurden keine Eintr&auml;ge gefunden.<\/span>";
		} else {
			var resultData = "<div><table  cellspacing='0' cellpadding='0' border='0'>";
			resultData += "<tr>";
			var r = 0;
			if (r<resultOfEvaluation.length) {
				for (var c in resultOfEvaluation[r])
					resultData += "<td class='resultHead'>"+c+"<\/td>";
				resultData += "<\/tr>"
			}
			for (var r = 0; r < resultOfEvaluation.length; r++) {
				resultData += "<tr>";
				for (var c in resultOfEvaluation[r])
					resultData += "<td class='resultData'>"+resultOfEvaluation[r][c]+"<\/td>";
				resultData += "<\/tr>";
			}
			out += resultData+"<\/table>";
		}
		out += "<\/div>"
		top.content.document.getElementById("sqlResults").innerHTML += out;
		top.content.location.href = "content.html#abfrage_"+(cntSQLStatements++);
	} else {
		alert(unescape("Die eingegebene SQL-Abfrage war nicht korrekt. Schau nochmal in die Hilfe.\n\nWahrscheinlich stimmen Tabellen- oder Spaltennamen nicht. Oder es wurde nicht vollst%E4ndig referenziert (Tabellenname.Spaltennname)."));
		return false;

	}
}

function breakIntoRows(sSQLString) {
	var sRes = sSQLString;
	sRes = sRes.replace(/(FROM)/,'<br>FROM');
	sRes = sRes.replace(/(WHERE)/,'<br>WHERE');
	sRes = sRes.replace(/(HAVING)/,'<br>HAVING');
	sRes = sRes.replace(/(ORDER)/,'<br>ORDER');
	sRes = sRes.replace(/(GROUP)/,'<br>GROUP');
	return sRes;
}

function initDB() {
	DBTest = new MyDB();
}

function editTable(sTableName) {
	editTableWin = window.open('editTable.html?tablename='+sTableName,'FAQ','left=50,top=50,toolbar=no,location=no,directories=no,status=no,scrollbars=yes,resizable=yes,copyhistory=no,width=700,height=600');
	if (editTableWin!=null) {
		if (editTableWin.opener==null) {
			editTableWin.opener = self;
		}
		editTableWin.focus();
	}
}

function getTableData(sTableName) {sendTableData(sTableName);}

function sendTableData(sTableName) {
	//alert(editTableWin.tablename);
	var curTable = DBTest.getAllTables()[DBTest.getTableIdx(sTableName)];
	var curTableDescr = curTable.getDescr();
	//editTableWin.document.f.tabledescr.value = replaceHtmlUmlaute(curTableDescr);
	editTableWin.document.getElementsByName("tabledescr")[0].innerHTML = replaceHtmlUmlaute(curTableDescr);
	
	var curScheme = curTable.getScheme();
	var curAttrName = "";
	var curAttrType = "";
	var foreignKey = "";
	for (var idx=0;idx<curScheme.length;idx++) {
		foreignKey = "";
		curAttrName = curScheme[idx][0];
		curAttrType = curScheme[idx][1];
		if (curTable.isForeignKey(curAttrName)) {
			foreignKey = curTable.getReference(curAttrName);
		}
		//alert("Fuege >"+curAttrName+"< ein\nType: "+curAttrType+"\nprimKey: "+curTable.isPrimaryKey(curAttrName)+"\nForeignKey: "+foreignKey);
		if (curTable.isPrimaryKey(curAttrName)) {
			editTableWin.hinzufuegen_oldAttribute(true,curAttrName,curAttrType,foreignKey);
		} else {	
			editTableWin.hinzufuegen_oldAttribute(false,curAttrName,curAttrType,foreignKey);
		}
	}

}

function replaceHtmlUmlaute(sString) {
	sString=sString.replace(/(<\Sl>)/g, "$1<br>");
	sString=sString.replace(/(<\/l\S>)/g, "$1<br>");
	sString=sString.replace(/(<\/h\S*>)/g, "$1<br>");

	sString = sString.replace(/(<br>)/g,'\n');
	sString = sString.replace(/(&uuml;)/g,'');
	sString = sString.replace(/(&auml;)/g,'');
	sString = sString.replace(/(&ouml;)/g,'');
	sString = sString.replace(/(&Uuml;)/g,'');
	sString = sString.replace(/(&Auml;)/g,'');
	sString = sString.replace(/(&Ouml;)/g,'');
	sString = sString.replace(/(&szlig;)/g,'');


	sString=sString.replace(//g, "\u00fc");
	sString=sString.replace(//g, "\u00f6");
	sString=sString.replace(//g, "\u00e4");
	sString=sString.replace(//g, "\u00dc");
	sString=sString.replace(//g, "\u00d6");
	sString=sString.replace(//g, "\u00c4");
	sString=sString.replace(//g, "\u00df");

	return sString;
}

function updateTableDisplay() {
	//Beim Lschen von Spalten wird falsch verschoben
	var resultString = "";
	for (var tableIdx = 0; tableIdx<DBTest.getAllTableNames().length;tableIdx++) {
		var curScheme = DBTest.getAllTables()[tableIdx].getScheme();	
		var curTable = DBTest.getAllTables()[tableIdx];
		if (tableIdx==0) resultString += "<table cellspacing='0' cellpadding='0' border='0'>";
		else resultString += "<table cellspacing='0' cellpadding='0' border='0' style='margin-top:2em'>";
		if (showTableDetails) {
			if (curTable.getDescr()!="")	resultString += "<tr><td valign='top' style='padding-left:0.2em; border-left:1px solid #000000; border-top:1px solid #000000' class='tableDescr'><b>Beschreibung:<\/b><\/td><td style='border-top:1px solid #000000; border-right:1px solid #000000' colspan='"+eval(curScheme.length)+"' class='tableDescr'>"+DBTest.getAllTables()[tableIdx].getDescr()+'<\/td><\/tr>';		
	
			//show references
			if (curTable.getAllReferences()!=null && DBTest.getAllTables()[tableIdx].getAllReferences()!="") {
				if (curTable.getDescr()!="") resultString += "<tr><td valign='top' style='padding-left:0.2em; border-left:1px solid #000000' class='tableref'><b>Referenzen:<\/b><\/td><td style='border-right:1px solid #000000' colspan='"+eval(curScheme.length)+"' class='tableref'>"+DBTest.getAllTables()[tableIdx].displayAllReferencesPairs()+'<\/td><\/tr>';
				else resultString += "<tr><td valign='top' style='padding-left:0.2em; border-left:1px solid #000000; border-top:1px solid #000000' class='tableref'><b>Referenzen:<\/b><\/td><td style='border-top:1px solid #000000; border-right:1px solid #000000' colspan='"+eval(curScheme.length)+"' class='tableref'>"+DBTest.getAllTables()[tableIdx].displayAllReferencesPairs()+'<\/td><\/tr>';
			}
		}
		//Building tablehead first
		resultString += "<tr><td class='name'>"+curTable.getName()+"<\/td>";
		for (var idx=0;idx<curScheme.length;idx++) {
			if (curTable.isPrimaryKey(curScheme[idx][0])) {
				if (curTable.isForeignKey(curScheme[idx][0]))
					resultString += "<td class='primarykeys'>"+curScheme[idx][0]+" ><\/td>";
				else
					resultString += "<td class='primarykeys'>"+curScheme[idx][0]+"<\/td>";
			} else {
				if (curTable.isForeignKey(curScheme[idx][0]))
					resultString += "<td class='attributes'>"+curScheme[idx][0]+" ><\/td>";
				else
					resultString += "<td class='attributes'>"+curScheme[idx][0]+"<\/td>";
			}
		}
		resultString += "<td>&nbsp;<\/td><\/tr>";
		//Adding tabledata
		if (curTable.getData()!="") {	//alert("no Data");
			resultString += DBTest.buildView(curTable.getName());
		}
		resultString += "<tr><td colspan='"+eval(curScheme.length+2)+"' align='right'><input type='button' onClick='top.head.editTable("+'"'+DBTest.getAllTableNames()[tableIdx]+'"'+")' value='Tabelle bearbeiten'><input type='button' onClick='top.head.newDataEntry("+'"'+DBTest.getAllTableNames()[tableIdx]+'",'+tableIdx+")' value='Neuer Eintrag'>";
		resultString += "<\/table>";
	}
	//alert("updateTableDisplay\n"+resultString);
	top.content.document.getElementById("tables").innerHTML = resultString;
}

function newDataEntry(sTableName,iTableIdx) {
	var curScheme = DBTest.getAllTables()[iTableIdx].getScheme();
	var newData = new Array();
	for (var i=0;i<curScheme.length;i++) {
		if (curScheme[i][1].toLowerCase()=="string") {
				newData[i] = "--";
		} else {
			newData[i] = 0;
		}
	}
	DBTest.insertData(sTableName,newData);
	updateTableDisplay();
}

function updateDataEntry(sTableName,rowIdx,columnIdx,newEntry) {
	DBTest.getAllTables()[DBTest.getTableIdx(sTableName)].replaceDataEntry(rowIdx,columnIdx,newEntry);
}

function deleteRowOfTable(rowIdx,sTableName) {
	DBTest.getAllTables()[DBTest.getTableIdx(sTableName)].deleteData(rowIdx);
	updateTableDisplay();
}

function resetInputField(tableName,xCoord,yCoord,newText) {
	top.content.document.getElementById("inputField_"+tableName+"_"+xCoord+yCoord).value = newText;
}

function getTrimPathScheme(sTableName) {
	var curScheme = DBTest.getAllTables()[DBTest.getTableIdx(sTableName)].getScheme();
	//alert("getTrimPathScheme\n"+curScheme);
	var sResult = sTableName+':{';
	for (var idx=0;idx<curScheme.length;idx++) {
		sResult += curScheme[idx][0]+': { type: "';
		//alert("type:"+curScheme[idx][1]);
		if (curScheme[idx][1].toLowerCase()=="string") sResult += 'String"}';
		else sResult += 'Number"}';
		if (idx!=curScheme.length-1) sResult += ',';
	}
	sResult += "}";
	//alert("getTrimPathScheme\n"+sResult);
	return sResult;
}

function getTrimPathTableData(sTableName) {
	var curScheme = DBTest.getAllTables()[DBTest.getTableIdx(sTableName)].getScheme();
	var curData = DBTest.getAllTables()[DBTest.getTableIdx(sTableName)].getData();
	//alert("getTrimPathTableData\n"+curScheme);
	var sResult = sTableName+':[';
	for (var idx=0;idx<curData.length;idx++) {
		sResult += "{";
		for (var dataIdx=0;dataIdx<curData[idx].length;dataIdx++) {
			if (curScheme[dataIdx][1].toLowerCase()=="string") {
				sResult += curScheme[dataIdx][0]+':'+"'"+curData[idx][dataIdx]+"'";
			} else {
				sResult += curScheme[dataIdx][0]+':'+curData[idx][dataIdx];			
			}
			if (dataIdx!=curData[idx].length-1) sResult += ',';
		}
		sResult += "}";
		if (idx!=curData.length-1) sResult += ',';
	}
	sResult += "]";
	//alert("getTrimPathTableData\n"+sResult);
	return sResult;
}

initDB();



/************************************************/
/****************** TESTAREA ********************/
/************************************************/
/*
DBTest = new MyDB();

DBTest.setName("Schule");

var newScheme = new Array();
newScheme[0] = new Array("Name","string");
newScheme[1] = new Array("Alter","number");
newScheme[2] = new Array("Adresse","string");
var primKeys = new Array("Name","Adresse");
var sDescr = "Die wichtigsten Daten der Lehrer.";
DBTest.addTable("Lehrer",newScheme,primKeys,null,sDescr);
DBTest.insertData("Lehrer",new Array("Meier",35,"Pfaffenhofen"));
DBTest.insertData("Lehrer",new Array("Schulze",34,"Freising"));
DBTest.insertData("Lehrer",new Array("Schmidt",31,"Dachau"));
DBTest.insertData("Lehrer",new Array("Huber",34,"Dachau"));
DBTest.insertData("Lehrer",new Array("Werner",55,"Freising"));

newScheme = new Array();
newScheme[0] = new Array("Name","string");
newScheme[1] = new Array("Groesse","number");
primKeys = new Array("Name");
sDescr = "";
DBTest.addTable("Klasse",newScheme,primKeys,null,sDescr);
DBTest.insertData("Klasse",new Array("7d",31));
DBTest.insertData("Klasse",new Array("7c",31));
DBTest.insertData("Klasse",new Array("6a",33));
DBTest.insertData("Klasse",new Array("5e",34));
DBTest.insertData("Klasse",new Array("10b",24));

newScheme = new Array();
newScheme[0] = new Array("Klasse","string");
newScheme[1] = new Array("Lehrer","string");
primKeys = new Array("Lehrer","Klasse");
var refTables = new Array("Lehrer","Klasse");
sDescr = "Relationship zur Bestimmung der Klassleiter.";
DBTest.addTable("ist_Klassleiter_von",newScheme,primKeys,refTables,sDescr);
DBTest.insertData("ist_Klassleiter_von",new Array("7d","Meier"));
DBTest.insertData("ist_Klassleiter_von",new Array("7c","Schmidt"));
DBTest.insertData("ist_Klassleiter_von",new Array("6a","Huber"));
DBTest.insertData("ist_Klassleiter_von",new Array("5e","Werner"));
DBTest.insertData("ist_Klassleiter_von",new Array("10b","Schulze"));

updateTableDisplay();
*/
/******************************************/
/*************  Trimpath Example  *********/
/******************************************/
/*
var tableData = { 
        Invoice  : [ { id: 1, total: 100, custId: 10 }, 
                     { id: 2, total: 200, custId: 10 }, 
                     { id: 3, total: 300, custId: 10 }, 
                     { id: 4, total: 400, custId: 20 } ],
        Customer : [ { id: 10, acctBalance: 1000 }, 
                     { id: 20, acctBalance: 2000 }, 
                     { id: 30, acctBalance: 3000 } ]
    			};

var schema = {
        Invoice  : { id          : { type: "String" },
                     total       : { type: "Number" },  
                     custId      : { type: "String" } },
        Customer : { id          : { type: "String" },
                     acctBalance : { type: "Number" } }
    };
    
// First we precompile the query language object with the schema...
var queryLang = top.head.TrimPath.makeQueryLang(schema);

alert(queryLang);
// Next, we do a SELECT statement.
var statement = queryLang.parseSQL(
  "SELECT Customer.id, Customer.acctBalance, Invoice.total " +
	  "FROM Customer, Invoice " +
	  "WHERE Customer.id = Invoice.custId " +
	  "ORDER BY Customer.id ASC");

alert(statement);
// Here we run the query...
var result = statement.filter(tableData);

 var out = "";
    for (var r = 0; r < result.length; r++) {
        for (var c in result[r])
            out += c + ": " + result[r][c] + ", ";
        out += "<br/>\n";
    }

alert(out);

// Tada!  That's it -- the results now holds the joined,
// filtered, and sorted output of our first query.

// Also, we can convert the statement back to a SQL string...
statement.toString() == 
   "SELECT Customer.id, Customer.acctBalance, Invoice.total " + 
		  "FROM Customer, Invoice " +
		  "WHERE Customer.id = Invoice.custId " +
		  "ORDER BY Customer.id ASC";

*/