function DBTable() {
	this.sName = "";
	this.aScheme = new Array(); // array starts with index 0
	this.aData = new Array(); //2-dim array; starts with 0 (name,type) [0][1] ?? Sicher??
	this.aReferencedBy = new Array(); //List of tables with a foreign key which references this table. This table cannot be deleted
	this.aReferences = new Array(); //List of all attribut-table-pairs -Liste der fremdschlssel
	this.aPrimaryKeys = new Array(); //List of all primaryKeys
	this.description = "";
}

DBTable.prototype.getName = function(){ return this.sName; };
DBTable.prototype.setName = function(sNewName) { this.sName = sNewName; } 
DBTable.prototype.getDescr = function(){ return this.description; };
DBTable.prototype.setDescr = function(sNewDescr) { this.description = sNewDescr; } 

DBTable.prototype.setScheme = _setScheme;             //Parameter:schemeArray      //DONE
DBTable.prototype.getScheme = _getScheme;             //Parameter:attributName     //DONE
DBTable.prototype.isInScheme = _isInScheme;           //Parameter:attributName     //DONE
DBTable.prototype.isNotInScheme = _isNotInScheme;     //Parameter:attributName     //DONE
DBTable.prototype.addToScheme = _addToScheme;         //Parameter:attributName     //DONE
DBTable.prototype.dropFromScheme = _dropFromScheme;   //Parameter:attributName     //DONE
DBTable.prototype.getAttributIdx = _getAttributIdx;   //Parameter:attributName     //DONE

DBTable.prototype.getPrimaryKeys = _getPrimaryKeys;   //Parameter:--
DBTable.prototype.setPrimaryKeys = _setPrimaryKeys;   //Parameter:Array of attributnames
DBTable.prototype.isPrimaryKey = _isPrimaryKey;   	  //Parameter:attributname

DBTable.prototype.setReferences = _setReferences;     //Parameter:Array of tablenames
DBTable.prototype.getAllReferences = _getAllReferences;//Parameter:--
DBTable.prototype.addReference = _addReference;   	  //Parameter:tablename
DBTable.prototype.deleteReference = _deleteReference; //Parameter:tablename
DBTable.prototype.checkForReferenceWith = _checkForReferenceWith; //Parameter:tablename

DBTable.prototype.setReferencesPair = _setReferencesPair;     				//Parameter:Array of Array(attributname,tablename)
DBTable.prototype.getAllReferencesPairs = _getAllReferencesPairs;			//Parameter:--
DBTable.prototype.getReference = _getReference;								//Parameter:attributename
DBTable.prototype.displayAllReferencesPairs = _displayAllReferencesPairs;	//Parameter:--
DBTable.prototype.isForeignKey = _isForeignKey;		  						//Parameter:attributename
DBTable.prototype.deleteForeignKey = _deleteForeignKey;		  				//Parameter:attributename

DBTable.prototype.deleteData = _deleteData;           //Parameter:dataIndex        //DONE
DBTable.prototype.deleteColumn = _deleteColumn;		  //Parameter:spaltenIdx	   //DONE
DBTable.prototype.insertData = _insertData;           //Parameter:dataArray        //DONE
DBTable.prototype.checkNewData = _checkNewData;       //Parameter:dataArray        //DONE
DBTable.prototype.getData = _getData;                 //Parameter:--               //DONE
DBTable.prototype.replaceDataEntry = _replaceDataEntry;//Parameter:--              //DONE
DBTable.prototype.getSelection = _getSelection;        //Parameter:idx             //DONE
DBTable.prototype.entryIsUnique = _entryIsUnique;//Parameter:AttributeIdx, newValue Prft, ob ein Wert eingefgt werden darf (wg primaryKey)//DONE
DBTable.prototype.entryIsNotUnique = _entryIsNotUnique;//Parameter:AttributeIdx, newValue //DONE

/******************************************/
/************** sourcecode ****************/
/******************************************/

/******************************************/
/************ scheme-methods **************/
/******************************************/
function _setScheme(aNewScheme) {
	this.aScheme = aNewScheme;
}

function _getScheme() {
	return this.aScheme;
}

function _addToScheme(sNewAttributName,sNewAttributType) {
	this.aScheme[this.aScheme.length] = new Array(sNewAttributName,sNewAttributType);
	//Dummy-Werte setzen - Autoincrement, da es ein Primrschlssel sein knnte
	var curValue = 1;
	var curIdx = this.aScheme.length-1;
	for (var i = 0;i<this.aData.length;i++) {
		this.aData[i][curIdx] = curValue;
		curValue++;
	}
}

function _isNotInScheme(sAttributName) { return !this.isInScheme(sAttributName); }

function _isInScheme(sAttributName) {
	for (var i=0;i<this.aScheme.length;i++) {
		if (this.aScheme[i][0]==sAttributName) return true;
	}
	return false;
}

function _dropFromScheme(sAttributName) {
	var curIdx = this.getAttributIdx(sAttributName);
	if (curIdx > -1) {
		this.aScheme = removeElementFromArray(this.aScheme,curIdx);
	} else {
		alert("_dropFromScheme\n Das Attribut '"+sAttributName+"' ist in der Tabelle '"+this.sName+"' nicht vorhanden.");
	}
}

function _getAttributIdx(sAttributName) {
	for (var i=0;i<this.aScheme.length;i++) {
		if (this.aScheme[i][0] == sAttributName) return i;
	}
	return -1;
}

function _getPrimaryKeys() {
	return this.aPrimaryKeys; 
}

function _setPrimaryKeys(aPrimKeys) {   //Parameter:Array of attributnames//
	this.aPrimaryKeys = aPrimKeys;
}

function _isPrimaryKey(sAttributeName) {
	for (var i=0;i<this.aPrimaryKeys.length;i++) {
		if (this.aPrimaryKeys[i] == sAttributeName) return true;
	}
	return false;
}

function _setReferences(aTableNames) {
	this.aReferencedBy = aTableNames;
}

function _getAllReferences() {
	return this.aReferencedBy;
}

function _addReference(sTableName) {
	var allReadyListed = false;
	for (var i=0;i<this.aReferencedBy.length;i++) {
		if (this.aReferencedBy[i] == sTableName) {allReadyListed = true;break;}
	}
	if (!allReadyListed) this.aReferencedBy[this.aReferencedBy.length] = sTableName;
}

function _deleteReference(sTableName) {
	var allReadyListed = false;
	var newReferenceList = new Array();
	for (var i=0;i<this.aReferencedBy.length;i++) {
		if (this.aReferencedBy[i] != sTableName) {
			newReferenceList[newReferenceList.length] = this.aReferencedBy[i];
		}
	}
	this.aReferencedBy = newReferenceList;
}

function _checkForReferenceWith(sTableName) {
	//alert("Currently checked: "+this.sName+"\nReferenz: "+sTableName+"\nReferenzen: "+this.aReferencedBy);
	if (this.aReferencedBy!=null) {
		for (var i=0;i<this.aReferencedBy.length;i++) {
			if (this.aReferencedBy[i] == sTableName) {
				return this.sName;
			}
		}
	}
	return "";
}

function _setReferencesPair(aPairs) {
	this.aReferences = aPairs;
}

function _getAllReferencesPairs() {
	return this.aReferences;
}

function _getReference(attributName) {
	if (this.aReferences!=null) {
		for (var i=0;i<this.aReferences.length;i++) {
			if (this.aReferences[i][0] == attributName) {
				return this.aReferences[i][1];
			}
		}
	}
	return "";
}

function _displayAllReferencesPairs() {
	var sRes = "<b>Attributname -> referenzierte Tabelle</b><br>";
	if (this.aReferences!=null) {
		for (var i=0;i<this.aReferences.length;i++) {
			sRes += this.aReferences[i][0] +" -> "+this.aReferences[i][1]+"<br>";
		}
	}
	return sRes;
}

function _isForeignKey(attributeName) {
	if (this.aReferences!=null) { //Gibt es berhaupt Referenzen?
		for (var i=0;i<this.aReferences.length;i++) {
			if (this.aReferences[i][0]==attributeName) return true;
		}
	}
	return false;
}

function _deleteForeignKey(attributeName) {
	//removeElementFromArray(aArray,elementIdx);
	alert("_deleteForeignKey\nLoesche "+attributeName+" aus \n"+this.aReferences);
	for (var i=0;i<this.aReferences.length;i++) {
		if (this.aReferences[i][0]==attributeName) {this.aReferences = removeElementFromArray(this.aReferences,i); break;}
	}
	alert(this.aReferences);
}

/******************************************/
/************ data-methods **************/
/******************************************/
function _deleteData(dataIdx) {
	//alert("Daten vor dem Entfernen\n"+this.aData+"\n Index="+dataIdx);
	if (dataIdx >= 0) {
		this.aData = removeElementFromArray(this.aData,dataIdx);
	} else {
		alert("_deleteData\n Das Tupel mit dem Index'"+dataIdx+"' existiert in der Tabelle '"+this.sName+"' exisitiert nicht.");
	}
	//alert("Daten nach dem Entfernen\n"+this.aData+"\n Index="+dataIdx);
}

//7.2.16 ergaenzt
function _deleteColumn(iColumnIdx) {
	tmpDataTable = new Array(); //Neue Tabelle mit Spalten wie das neue Schema
	for (var reihenIdx = 0;reihenIdx<this.aData.length;reihenIdx++) {
		neueDatenReihe = new Array();
		for (var spaltenIdx = 0;spaltenIdx<this.aData[0].length;spaltenIdx++) {
			if (spaltenIdx!=iColumnIdx) {
				neueDatenReihe[neueDatenReihe.length] = this.aData[reihenIdx][spaltenIdx];
			}
		}
		tmpDataTable[tmpDataTable.length] = neueDatenReihe;
	}
	this.aData = tmpDataTable;
}

function _insertData(aArray) {
	if (this.aScheme.length==0) {
		alert("_insertData\n Es wurde noch kein Schema bei der Tabelle '"+this.sName+"' festgelegt.");	
		return;
	}
	if (this.checkNewData(aArray))	{//Everything is okay, so
		this.aData[this.aData.length] = aArray;
 	} else {
 		return false;
 	}
}

function _checkNewData(aArray) {
	//Check for length
	if (this.aScheme.length<aArray.length) {
		alert("_checkNewData\n Es wurden zu viele Daten weitergegegeben.\nScheme: \n"+this.aScheme+"\n Ihre Daten:\n"+aArray);
		return false;
	}
	if (this.aScheme.length>aArray.length) {
		alert("_checkNewData\n Es wurden zu wenig Daten weitergegegeben.\nScheme: \n"+this.aScheme+"\n Ihre Daten:\n"+aArray);
		return false;
	}
	//Check for types
	for (var i = 0;i<this.aScheme.length;i++) {
		if (this.aScheme[i][1].toLowerCase() != typeof aArray[i]) {
			alert("_checkNewData\n Der "+i+".te Dateneintrag >"+aArray[i]+"< hat den Typ '"+(typeof aArray[i])+"'.\nEs muss aber ein '"+this.aScheme[i][1].toLowerCase()+"' Datentyp sein.");
			return false;
		}
	}
	return true;
}

function _getData(bDebugModus) {
	if (bDebugModus) {
		var sResult = "";
		for (var i = 0;i<this.aData.length;i++) {
			for (var j = 0;j<this.aScheme.length;j++) {
				sResult += this.aData[i][j]+"  ";
			}
			sResult += "\n";
		}
	} else {
		var sResult = this.aData;
	}
	return sResult;
}

function _replaceDataEntry(tupelIdx,dataIdx,sNewEntry) {
	//alert("_replaceDataEntry\n"+this.aData);
	//alert("_replaceDataEntry\n"+" tupelIdx: "+tupelIdx+"\n dataIdx: "+dataIdx+"\n sNewEntry: "+sNewEntry);
	for (var i = 0;i<this.aData.length;i++) { //Zeile bzw. Tupel finden
		if (i==tupelIdx) {
			for (var j = 0;j<this.aScheme.length;j++) { //Spalte bzw. 
				if (j==dataIdx) {
					if (this.aScheme[j][1]=="number" && isNaN(Number(sNewEntry))) {
						alert("_replaceDataEntry\n Im "+eval(i+1)+".te Datensatz in der Spalte '"+this.aScheme[j][0]+"' ist der falsche Datentyp aufgetreten. Anstelle von '"+(typeof sNewEntry)+"' muss ein '"+this.aScheme[j][1]+"' Datentyp benutzt werden.");
						sNewEntry = 0;
						this.aData[i][j] = sNewEntry;
						resetInputField(this.sName,i,j,sNewEntry);
					} else {
						sNewEntry = sNewEntry.replace(/+/g,"\u00DC");
						sNewEntry = sNewEntry.replace(/+/g,"\u00D6");
						sNewEntry = sNewEntry.replace(/+/g,"\u00C4");
						sNewEntry = sNewEntry.replace(/+/g,"\u00FC");
						sNewEntry = sNewEntry.replace(/+/g,"\u00E4");
						sNewEntry = sNewEntry.replace(/+/g,"\u00F6");
						sNewEntry = sNewEntry.replace(/+/g,"\u00DF");
						sNewEntry = sNewEntry.replace(/\s+/," ");
						if (sNewEntry=="") {
							sNewEntry = "--";
						}
						//Prfen ob nderung eines primaryKey
						if (this.isPrimaryKey(this.aScheme[j][0])) { //aScheme[j][1] gibt den Typ wieder
							//Prfen, ob Eintrag einmalig ist
							var possibleTupel = this.aData[i];
							possibleTupel[j] = sNewEntry;
							//alert("possibleTupel\n"+possibleTupel);
							//Herausfinden, welche Spalten primKeys sind
							var aPrimKeysIdx = new Array();
							for (var curSpalte = 0;curSpalte<this.aScheme.length;curSpalte++) {
								if (this.isPrimaryKey(this.aScheme[curSpalte][0])) aPrimKeysIdx[aPrimKeysIdx.length]=curSpalte;
							}
							var entryOkay = true;
							var aPrimKeys_proReihe = new Object();
							var curReihenPrimKey = "";
							for (var curReihe=0;curReihe<this.aData.length;curReihe++) {
								curReihenPrimKey = "";
								for (var curPrimIdx=0;curPrimIdx<aPrimKeysIdx.length;curPrimIdx++) {
									curReihenPrimKey+=this.aData[curReihe][aPrimKeysIdx[curPrimIdx]];
								}
								if (aPrimKeys_proReihe[curReihenPrimKey]!=null) {
									entryOkay = false;
									alert(unescape("Durch den Eintrag "+sNewEntry+" ist der Prim%E4schl%FCssel nicht mehr eindeutig."));
								} else {
									aPrimKeys_proReihe[curReihenPrimKey] = true;
								}
							}
						}
						if (entryOkay==false) sNewEntry = "--";
						this.aData[i][j] = sNewEntry;
						resetInputField(this.sName,i,j,sNewEntry);
						break;
					}
				}
			}
			break;
		}
	}
	//alert("_replaceDataEntry\n"+this.aData);
}

function _getSelection(idx) {
	var curSelection = new Array();
	for (var l = 0;l<this.aData.length;l++) { //Zeile bzw. Tupel finden
		curSelection[curSelection.length] = this.aData[l][idx];
	}
	return curSelection;
}

function _entryIsUnique(attributeIdx,newEntry,reihenIdx) {
	return !this.entryIsNotUnique(attributeIdx,newEntry,reihenIdx);
}

function _entryIsNotUnique(attributeIdx,newEntry,reihenIdx) {
	for (var l = 0;l<this.aData.length;l++) { //Zeile bzw. Tupel finden
		if (this.aData[l][attributeIdx] == newEntry && reihenIdx!=l) return true;
	}
	return false;
}